package org.volt.impl.client;

import net.minecraft.client.Minecraft;
import org.volt.api.client.IClient;
import org.volt.api.event.IEventBus;
import org.volt.api.module.IModule;
import org.volt.api.module.IModuleManager;
import org.volt.impl.event.EventBus;
import org.volt.impl.module.ModuleManager;
import org.volt.impl.module.misc.TestModule;

/**
 * This is essentially the core of the client,
 * holding all instances of managers and similar in one place
 * @author marie
 */
public final class Volt implements IClient
{
    /**
     * This instance is to be used every time this class is called
     */
    public static final Volt SINGLETON = new Volt();

    /**
     * The EventBus made for Volt, mostly meant to be used for modules
     */
    private final IEventBus eventBus = new EventBus();

    /**
     * The ModuleManager made for Volt, holds all modules
     */
    private final IModuleManager moduleManager = new ModuleManager();

    @Override
    public void initialize()
    {
        moduleManager.initialize();
    }

    @Override
    public IEventBus getEventBus()
    {
        return eventBus;
    }

    @Override
    public IModuleManager getModuleManager()
    {
        return moduleManager;
    }
}
