package org.volt.api.module;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Holds information like name, spaced out name and category
 * @author marie
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface ModuleInfo
{
    /**
     * @return The modules name (e.g. "TestModule")
     */
    String name();

    /**
     * @return The modules name with spaces (e.g. "Test Module")
     */
    String spacedName();

    /**
     * @return The modules category
     */
    IModule.Category category();
}
