package org.volt.api.module;

import org.volt.api.event.*;

/**
 * Holds the current parent module state
 * @see IModule
 * @author marie
 */
public interface IModuleStateHolder
{
    /**
     * The toggled state indicates that the module
     * is currently registered to recieve events
     * @see IEventBus
     * @return The modules toggled state
     */
    boolean isToggled();

    /**
     * Switches the modules toggle state and (un)registers
     * the module from the eventbus based on that
     * @see IEventBus
     */
    void toggle();

    /**
     * @return The modules module info annotation instance
     */
    ModuleInfo getModuleInfo();
}
