package org.volt.api.module;

/**
 * Manages all modules
 * @see IModule
 * @author marie
 */
public interface IModuleManager
{
    /**
     * Initializes the module manager and registers all modules
     */
    void initialize();

    /**
     * @param module Module to register
     */
    void registerModule(final IModule module);

    /**
     * @param clazz Input class
     * @return The registered module instance that matches the input class
     * @param <T> An instance of IModule
     */
    <T> T getModuleByClass(final Class<T> clazz);

    /**
     * @param clazz Module class
     * @return Module state holder with given module class as parent
     */
    IModuleStateHolder getModuleStateByClass(final Class<?> clazz);

}
