package org.volt.api.module;

/**
 * API interface to get certain module properties
 * @author marie
 */
public interface IModule
{
    /**
     * The suffix is something displayed after the module name
     * inside the arraylist given that the user wants to do so
     * @return The modules suffix
     */
    default String getSuffix()
    {
        return "";
    }

    /**
     * Executes code that the modules uses to enable
     */
    default void onEnable() {}

    /**
     * Executes code that the modules uses to disable
     */
    default void onDisable() {}

    enum Category
    {
        COMBAT, MOVEMENT, MISC, RENDER, WORLD
    }
}
