package org.volt.api.event;

/**
 * Manages everything related to events
 * @see EventReceiver
 * @see IEvent
 * @author marie
 */
public interface IEventBus
{
    /**
     * Calls all methods related to the given event
     * @param event Event to call methods with
     * @see IEventBus#register(Object)
     */
    <T> void call(final T event);

    /**
     * Registers all methods inside a class instance to receive event calls
     * @param o Class instance
     * @see IEventBus#unregister(Object)
     */
    void register(final Object o);

    /**
     * Unregisters all methods from a specified class instance
     * @param o Class instance
     * @see IEventBus#register(Object)
     */
    void unregister(final Object o);

}
