package org.volt.api.client;

import org.volt.api.event.IEventBus;
import org.volt.api.module.IModuleManager;

/**
 * API instance of the main client manager class
 * @author marie
 */
public interface IClient
{
    /**
     * Initializes everything that needs to be initialized <b>after</b> the game has launched
     */
    void initialize();

    /**
     * @return Currently used eventbus instance
     * @see IEventBus
     */
    IEventBus getEventBus();

    /**
     * @return Currently used module manager instance
     * @see IModuleManager
     */
    IModuleManager getModuleManager();
}
