package org.lwjgl.openal;

import java.util.HashMap;
import java.util.Map;

public class SoundSystemConfig {
    public static final Object THREAD_SYNC = new Object();

    private static final Map<String, Class<?>> codecRegistry = new HashMap<>();

    public static void setCodec(String extension, Class<?> codec) {
        if (extension == null || codec == null) {
            throw new IllegalArgumentException("Codec extension or class cannot be null.");
        }
        codecRegistry.put(extension.toLowerCase(), codec);
    }

    public static Class<?> getCodec(String extension) {
        return codecRegistry.get(extension.toLowerCase());
    }
}