import discord
from discord.ext import commands
from discord import Interaction
import requests

client = commands.Bot(command_prefix = "$", intents = discord.Intents.all())

@client.event
async def on_ready():
    await client.tree.sync()
    await client.change_presence(
        activity = discord.activity.Game("Vectus"), 
        status = discord.Status.do_not_disturb
        )
    print(f"{client.user.name} is ready!")

@client.tree.command(name = "ping", description = "Returns the bot's latency in milliseconds.")
async def ping(interaction : Interaction):
    await interaction.response.send_message(f"Pong! {round(client.latency*1000)}ms")

@client.tree.command(name="users", description="Returns a list of registered users")
async def users(interaction: Interaction):
    print(f"{interaction.user.name} used /users")
    allowed_roles = [1193235355713937487, 1193603786032287774, 1193235355734913148, 1197278104972951562]
    user_roles = interaction.user.roles
    if any(role.id in allowed_roles for role in user_roles):
        url = 'https://pastebin.com/raw/kctHsZKt'
        response = requests.get(url)
        
        if response.status_code == 200:
            data = response.text.split(',')
            embed = discord.Embed(
                title='User List',
                description='List of registered users:',
                color=discord.Color.green()
            )
            for user_info in data:
                user_data = user_info.split(':')
                username = user_data[1]
                hwid = '✅' if user_data[3] else '❌'
                embed.add_field(name=username, value=f'\nHWID Set: {hwid}', inline=False)
            await interaction.response.send_message(embed=embed, ephemeral=True)
        else:
            await interaction.response.send_message('Error fetching user list', ephemeral=True)
    else:
        await interaction.response.send_message("You do not have permission to use this command.", ephemeral=True)

@client.tree.command(name="download", description="Get a download link for Vectus")
async def download(interaction: Interaction):
    print(f"{interaction.user.name} used /download")
    allowed_roles = [1193235355713937487, 1193603786032287774, 1193235355734913148, 1197278104972951562]
    user_roles = interaction.user.roles
    if any(role.id in allowed_roles for role in user_roles):
        embed = discord.Embed(
            title='Download Vectus',
            description='To download the client, click on the link and press download',
            color=discord.Color.blurple()
        )
        embed.add_field(name="Link:", value="https://workupload.com/file/rA5ye7pDFtD", inline=True)
        await interaction.response.send_message(embed=embed, ephemeral=True)
    else:
        await interaction.response.send_message("You do not have permission to use this command.", ephemeral=True)

@client.tree.command(name="lookup", description="Get data for a specific user")
async def lookup(interaction: Interaction, username: str):
    print(f"{interaction.user.name} used /lookup for {username}")
    allowed_roles = [1193235355734913148, 1197278104972951562]
    user_roles = interaction.user.roles
    if any(role.id in allowed_roles for role in user_roles):
        url = 'https://pastebin.com/raw/kctHsZKt'
        response = requests.get(url)
        
        if response.status_code == 200:
            data = response.text.split(',')
            found_user = None
            for user_info in data:
                user_data = user_info.split(':')
                if user_data[1].lower() == username.lower():
                    found_user = user_data
                    break

            if found_user:
                uid = f'``{found_user[2]}``'
                hwid = f'``{found_user[3]}``'
                rank = f'``{found_user[4].capitalize()}``'
                embed = discord.Embed(
                    title=f'Looked up account {username}:',
                    color=discord.Color.blue()
                )
                embed.add_field(name='Username', value=f'``{found_user[1]}``', inline=False)
                embed.add_field(name='UID', value=uid, inline=False)
                embed.add_field(name='HWID', value=hwid, inline=False)
                embed.add_field(name='Rank', value=rank, inline=False)

                await interaction.response.send_message(embed=embed, ephemeral=True)
            else:
                await interaction.response.send_message(f'User `{username}` not found', ephemeral=True)
        else:
            await interaction.response.send_message('Error fetching user list', ephemeral=True)
    else:
        await interaction.response.send_message("You do not have permission to use this command.", ephemeral=True)

@client.tree.command(name="info", description="Get your account info")
async def dm_lookup(interaction: Interaction):
    print(f"{interaction.user.name} used /info in DMs")
    if interaction.guild is None:
        user_id = str(interaction.user.id)

        url = 'https://pastebin.com/raw/kctHsZKt'
        response = requests.get(url)

        if response.status_code == 200:
            data = response.text.split(',')
            found_user = None
            for user_info in data:
                user_data = user_info.split(':')
                if user_data[0] == user_id:
                    found_user = user_data
                    break

            if found_user:
                username = f'``{found_user[1]}``'
                uid = f'``{found_user[2]}``'
                hwid = f'``{found_user[3]}``'
                rank = f'``{found_user[4].capitalize()}``'
                
                embed = discord.Embed(
                    title=f'Your Information:',
                    color=discord.Color.brand_green()
                )
                embed.add_field(name='Username', value=username, inline=False)
                embed.add_field(name='UID', value=uid, inline=False)
                embed.add_field(name='HWID', value=hwid, inline=False)
                embed.add_field(name='Rank', value=rank, inline=False)

                await interaction.user.send(embed=embed)
            else:
                await interaction.response.send('User not found based on your Discord ID.')
        else:
            await interaction.response.send('Error fetching user list.')
    else:
        await interaction.response.send_message('This command can only be used in DMs.')


client.run("MTE5OTcyMjkxODg2MzcwMDAxOA.GuGxXJ.09roNAxV4-k_JpyEFI1hr-dbKxyEF_RU3yCV5A")
