package war.metaphor.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JavaInternalClasses {
    public static final Map<String, byte[]> classes = new HashMap<>();

    static {
        for (File file : new File(System.getProperty("java.home"), "jmods").listFiles()) {
            if (!file.getAbsolutePath().endsWith(".jmod")) {
                continue;
            }

            try (ZipFile jarFile = new ZipFile(file))  {
                Enumeration<? extends ZipEntry> entries = jarFile.entries();

                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().endsWith(".class")) {
                        byte[] classBytes = jarFile.getInputStream(entry).readAllBytes();
                        String name = entry.getName();
                        name = name.substring(8, name.length() - 6);
                        if (name.equals("module-info")) continue;
                        classes.put(name, classBytes);
                    }
                }
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}