package war.metaphor.mutator.misc;

import org.objectweb.asm.tree.FieldNode;
import war.configuration.ConfigurationSection;
import war.jnt.annotate.Level;
import war.jnt.annotate.Stability;
import war.jnt.utility.mapping.Mapping;
import war.jnt.utility.mapping.impl.MemberIdentity;
import war.metaphor.base.ObfuscatorContext;
import war.metaphor.mutator.MappingMutator;
import war.metaphor.tree.ClassField;
import war.metaphor.tree.JClassNode;
import war.metaphor.util.Dictionary;
import war.metaphor.util.Purpose;

import java.util.HashMap;
import java.util.Map;

@Stability(Level.HIGH)
public class FieldRenameMutator extends MappingMutator {

    public FieldRenameMutator(ObfuscatorContext base, ConfigurationSection config) {
        super(base, config);
    }

    @Override
    public void run(ObfuscatorContext base) {
        Map<String, String> mapping = new HashMap<>();

        for (JClassNode classNode : base.getClasses()) {
            if (classNode.isExempt()) continue;

            for (FieldNode field : classNode.fields) {

                if (classNode.isExempt(field)) continue;

                ClassField self = ClassField.of(classNode, field);

                if (mapping.containsKey(self.toString()))
                    continue;

                String newName = Dictionary.gen(1, Purpose.FIELD);

                String id = classNode.name + "." + field.name + field.desc;
                mapping.put(id, newName);

                base.getRepository().add(new Mapping(
                        new MemberIdentity(".m_same " + classNode.name, field.name, ""),
                        new MemberIdentity(classNode.name, newName, "")
                ));
            }
        }

        map(base, mapping);

    }
}
