package war.metaphor.engine.modules;

import org.objectweb.asm.tree.InsnList;
import war.metaphor.engine.Context;
import war.metaphor.util.builder.InsnListBuilder;

public class RotateLeftMod implements Module {

    @Override
    public void run(Context context) {
        int key = context.popStack();
        int curr = context.popStack();
        key = key % 16;
        int v = Integer.rotateLeft(curr, key);
        context.pushStack(v);
    }

    private int bitsLeft(int bits) {
        if (bits < 0 || bits > 32) {
            throw new IllegalArgumentException("Number of bits must be between 0 and 32.");
        }
        return ((1 << bits) - 1) << (32 - bits);
    }

    @Override
    public Class<? extends Module> inverse() {
        return RotateRightMod.class;
    }

    @Override
    public String getSourceInstructions(Context context) {
        throw new UnsupportedOperationException("Source instructions not implemented for RotateLeftMod");
    }

    @Override
    public InsnList getInstructions(Context context) {
        int key = context.popStack();
        key = key % 16;
        return InsnListBuilder
                .builder()
                .dup()
                .constant(-key)
                .ishl()
                .swap()
                .constant(key)
                .iushr()
                .ior()
                .build();
    }
}
