package war.jnt.obfuscation;

import war.jnt.core.Processor;
import war.jnt.core.header.Header;
import war.jnt.core.source.Source;
import war.metaphor.engine.Context;
import war.metaphor.engine.Engine;

import java.util.HashMap;
import java.util.Map;

public class StringLookup {

    public static Map<Engine, Integer> engines = new HashMap<>();

    public static int add(Engine engine) {
        return engines.computeIfAbsent(engine, _ -> engines.size());
    }

    public static void add(Engine engine, Integer id) {
        engines.put(engine, id);
    }

    public static void make(Processor processor) {

//        String header = "#pragma once\n" +
//                "#include \"jni.h\"\n" +
//                "#include <stdio.h>\n" +
//                "#include <stdint.h>\n" +
//                "#include <stdatomic.h>\n\n" +
//                "#include <emmintrin.h>\n\n" +
//                "jchar decode_character(jchar value, jint id);\n" +
//                "jchar* jnt_decode_string(jchar* str, jint length, jint id, jint* should_decode);\n\n";

        String header = """
                #pragma once
                #include "jni.h"
                #include <stdint.h>
                #include <stdatomic.h>
                #include <emmintrin.h>
                #include <immintrin.h>
                
                jchar decode_character(jchar value, jint id);
                jchar* jnt_decode_string(jchar* str, jint length, jint id);
                """;

        processor.getHeaders().add(
                new Header("lib/string_obfuscation.h", header)
        );

        StringBuilder source = new StringBuilder();

        source.append("#include \"string_obfuscation.h\"\n\n");

        source.append("\njchar decode_character(jchar value, jint id) {\n");
        source.append("\tswitch (id) {\n");
        engines.forEach((engine, id) -> {
            source.append("\tcase ").append(id).append(":\n");
            source.append("\t").append(MutationUtil.VOLATILE_ASM);
            Context ctx = engine.getContext();
            ctx.varName = "value";
            source.append(engine.getSourceInstructions());
            source.append("\t\treturn value;\n");
        });
        source.append("\tdefault:\n");
        source.append("\t\treturn value;\n");
        source.append("\t}\n");
        source.append("}\n\n");

        source.append("jchar* jnt_decode_string(jchar* str, jint length, jint id) {\n");
        source.append("\tfor (jint i = 0; i < length; ++i) {\n");
        source.append("\t\tstr[i] = decode_character(str[i], id);\n");
        source.append("\t}\n");
        source.append("\treturn str;\n");
        source.append("}\n\n");

        processor.getSources().add(
                new Source("lib/string_obfuscation.c", source.toString())
        );

    }

    public static String toUTF16(String str) {
        StringBuilder cn = new StringBuilder();
        cn.append("(jchar[]) {");
        for (char c : str.toCharArray()) {
            cn.append(" 0x")
                    .append(String.format("%04X", (int) c))
                    .append(", ");
        }
        if (!str.isEmpty()) cn.delete(cn.length() - 2, cn.length());
        cn.append(" }");
        return cn.toString();
    }
}
