package war.jnt.core.code.impl.invoke;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.MethodInsnNode;
import war.jnt.cache.Cache;
import war.jnt.cache.struct.CachedMethod;
import war.jnt.core.code.UnitContext;
import war.jnt.dash.Level;
import war.jnt.dash.Logger;
import war.jnt.dash.Origin;
import war.jnt.fusebox.impl.VariableManager;

// may allah smite this shit into hell
// TODO: rewrite.
public class LookupUnit implements Opcodes {

    private static final Logger logger = Logger.INSTANCE;

    public static Lookup process(MethodInsnNode insn, UnitContext ctx, VariableManager varMan, Boolean shouldIntrinsic) {
        // null out for intrinsics
        if (shouldIntrinsic) {
            if (insn.name.equals("length") && insn.owner.equals("java/lang/String")) {
                return null;
            } else if (insn.name.equals("getClass") && insn.owner.equals("java/lang/Object")) {
                return null;
            } else if (insn.name.equals("isEmpty") && insn.owner.equals("java/lang/String")) {
                return null;
            }
        }

        return switch (insn.getOpcode()) {
            case INVOKESTATIC -> {
                String lookupVar = varMan.newLookup();
                String klassVar = varMan.newClass();

                int idx = Cache.Companion.request_klass(insn.owner);
                int methodIdx = Cache.Companion.request_method(new CachedMethod(insn.owner, insn.name, insn.desc, true));

                ctx.fmtAppend("\tjclass %s = request_klass(env, %d);\n", klassVar, idx);
                ctx.fmtAppend("\tjmethodID %s = request_method(env, %s, %d);\n", lookupVar, klassVar, methodIdx);

                yield new Lookup(lookupVar, klassVar);
            }
            case INVOKEVIRTUAL, INVOKESPECIAL, INVOKEINTERFACE -> {
                String lookupVar = varMan.newLookup();
                String klassVar = varMan.newClass();

                int idx = Cache.Companion.request_klass(insn.owner);
                int methodIdx = Cache.Companion.request_method(new CachedMethod(insn.owner, insn.name, insn.desc, false));

                ctx.fmtAppend("\tjclass %s = request_klass(env, %d);\n", klassVar, idx);
                ctx.fmtAppend("\tjmethodID %s = request_virtual(env, %s, %d);\n", lookupVar, klassVar, methodIdx);
                yield new Lookup(lookupVar, klassVar);
            }
            default -> {
                logger.logln(Level.FATAL, Origin.CORE, "Failed to transpile method lookup.");
                yield null;
            }
        };
    }
}
