package war.jnt.core.code.impl.field

import org.apache.commons.lang3.RandomUtils
import org.objectweb.asm.Opcodes.*
import org.objectweb.asm.tree.FieldInsnNode
import war.jnt.cache.Cache.Companion.request_field
import war.jnt.cache.Cache.Companion.request_klass
import war.jnt.cache.struct.CachedField
import war.jnt.core.code.UnitContext
import war.jnt.core.vm.TempJumpVM
import war.jnt.fusebox.impl.Internal
import war.jnt.fusebox.impl.VariableManager

// absolute fucking maggot code
class FieldUnit {
    companion object {
        private fun fieldName(id: Int): String = "field$id"
        private fun klassName(id: Int): String = "fklass$id"

        fun process(insn: FieldInsnNode, ctx: UnitContext, tjvm: TempJumpVM, varMan: VariableManager) {
            val func = Internal.resolveFieldOffset(insn.desc, insn.opcode)

            val name = fieldName(ctx.fieldManager.fields)
            val klassName = klassName(ctx.fieldManager.classes)
            val type = Internal.fromFieldType(insn.desc)

            val xorKey = RandomUtils.nextInt()

            when (insn.opcode) {
                GETSTATIC -> {
                    val psh = Internal.computePush(ctx.tracker)

                    val idx = request_klass(insn.owner)
                    val fieldIdx = request_field(CachedField(insn.owner, insn.name, insn.desc, true))

                    ctx.append("\tjclass $klassName = request_klass(env, $idx);\n")
                    ctx.append("\tjfieldID $name = request_field(env, $klassName, $fieldIdx);\n")

                    tjvm.makeValue(func.offset.xor(xorKey))
                    ctx.append("\t$psh$type = ((${func.value} (*)(JNIEnv *, jclass, jfieldID)) (*((void **)*env + (*(volatile int *)&output ^ $xorKey))))(env, $klassName, $name);\n")

                    ctx.fieldManager.fields++
                    ctx.fieldManager.classes++
                }
                GETFIELD -> {
                    val pop = Internal.computePop(ctx.tracker)
                    val psh = Internal.computePush(ctx.tracker)
                    val type = Internal.fromFieldType(insn.desc)

                    val npeKlass = request_klass("java/lang/NullPointerException")
                    ctx.fmtAppend(
                        "\tif (%s.l == NULL) { (*env)->ThrowNew(env, request_klass(env, $npeKlass), \"instance is null\"); goto %s; }\n",
                        pop, ctx.handlerLabel
                    )

                    val idx = request_klass(insn.owner)
                    val fieldIdx = request_field(CachedField(insn.owner, insn.name, insn.desc, false))

                    ctx.append("\tjclass $klassName = request_klass(env, $idx);\n")
                    ctx.append("\tjfieldID $name = request_ifield(env, $klassName, $fieldIdx);\n")
                    tjvm.makeValue(func.offset.xor(xorKey))
                    ctx.fmtAppend("\t%s%s = ((${func.value} (*)(JNIEnv *, jobject, jfieldID)) (*((void **)*env + (*(volatile int *)&output ^ $xorKey))))(env, %s.l, %s);\n", psh, type, pop, name)

                    ctx.fieldManager.fields++
                    ctx.fieldManager.classes++
                }
                PUTSTATIC -> {
                    val pop = Internal.computePop(ctx.tracker)

                    val idx = request_klass(insn.owner)
                    val fieldIdx = request_field(CachedField(insn.owner, insn.name, insn.desc, true))

                    ctx.append("\tjclass $klassName = request_klass(env, $idx);\n")
                    ctx.append("\tjfieldID $name = request_field(env, $klassName, $fieldIdx);\n")
                    tjvm.makeValue(func.offset.xor(xorKey))
                    ctx.append("\t((void (*)(JNIEnv *, jclass, jfieldID, ${func.value})) (*((void **)*env + (*(volatile int *)&output ^ $xorKey))))(env, $klassName, $name, $pop$type);\n")

                    ctx.fieldManager.fields++
                    ctx.fieldManager.classes++
                }
                PUTFIELD -> {
                    val value = Internal.computePop(ctx.tracker)
                    val obj = Internal.computePop(ctx.tracker)

                    val npeKlass = request_klass("java/lang/NullPointerException")
                    ctx.fmtAppend(
                        "\tif (%s.l == NULL) { (*env)->ThrowNew(env, request_klass(env, $npeKlass), \"instance is null\"); goto %s; }\n",
                        obj, ctx.handlerLabel
                    )

                    val idx = request_klass(insn.owner)
                    val fieldIdx = request_field(CachedField(insn.owner, insn.name, insn.desc, false))

                    ctx.append("\tjclass $klassName = request_klass(env, $idx);\n")
                    ctx.append("\tjfieldID $name = request_ifield(env, $klassName, $fieldIdx);\n")
                    tjvm.makeValue(func.offset.xor(xorKey))
                    ctx.append("\t((void (*)(JNIEnv *, jobject, jfieldID, ${func.value})) (*((void **)*env + (*(volatile int *)&output ^ $xorKey))))(env, $obj.l, $name, $value$type);\n")

                    ctx.fieldManager.fields++
                    ctx.fieldManager.classes++
                }
            }
        }
    }
}