package war.jnt.core.code.impl;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.InsnNode;
import war.jnt.cache.Cache;
import war.jnt.core.code.UnitContext;
import war.jnt.core.vm.TempJumpVM;
import war.jnt.fusebox.impl.Internal;
import war.metaphor.util.interfaces.IRandom;

public class ThrowUnit implements Opcodes, IRandom {

    public static void process(InsnNode insn, UnitContext ctx, TempJumpVM tjvm) {
        int idx = Cache.Companion.request_klass("java/lang/NullPointerException");
        ctx.fmtAppend("\t{\n");
        ctx.fmtAppend("\t\tjthrowable thrown = (jthrowable) %s.l;\n", Internal.computePop(ctx.getTracker()));
        ctx.fmtAppend("\t\tif (thrown == NULL) {\n");
        ctx.fmtAppend("\t\t\tjclass npe = request_klass(env, %s);\n", idx);
        tjvm.makeValue(14);
        ctx.fmtAppend("\t\t\t((jint (*)(JNIEnv *, jclass, const char *)) (*((void **)*env + *(volatile int *)&output)))(env, npe, \"NullPointerException\");\n");
        ctx.fmtAppend("\t\t} else {\n");
        tjvm.makeValue(13);
        ctx.fmtAppend("\t\t\t((jint (*)(JNIEnv *, jthrowable)) (*((void **)*env + *(volatile int *)&output)))(env, thrown);\n");
        ctx.fmtAppend("\t\t}\n");
        ctx.fmtAppend("\t}\n");
    }
}
