package war.ice;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class Ice {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please provide a file to interpret");
            return;
        }

        String sourceFile = args[0];
        try {
            String source = new String(Files.readAllBytes(Paths.get(sourceFile)));
            Lexer lexer = new Lexer(source);
            List<Token> tokens = lexer.tokenize();
            for (Token token : tokens) {
                System.out.println(token);
            }

            Parser parser = new Parser(tokens);
            List<Statement> statements = parser.parse();

            Interpreter interpreter = new Interpreter();
            interpreter.interpret(statements);
        } catch (Exception e) {
            System.err.println("Error interpreting file: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
} 