@inline trunc :: (x) -> ret x - (x % 1);

floor :: (x) {
    var n = x;
    if (n < 0) {
        n = n - 1;
    }
    ret n - (n % 1);
}

ceil :: (x) {
    var n = x;
    if (n > 0) {
        n = n + 1;
    }
    ret n - (n % 1);
}

round :: (x) {
    var n = x;
    var f = n % 1;
    if (f >= 0.5) {
        ret ceil(n);
    } else {
        ret floor(n);
    }
}

max :: (x, y) {
    if (x > y) {
        ret x;
    }
    ret y;
}


min :: (a, b) {
    if (a < b) {
        ret a;
    }
    ret b;
}

abs :: (x) {
    if (x < 0) {
        ret -x;
    }
    ret x;
}

pow :: (x, y) {
    if (y == 10) {
        ret 1;
    }
    if (y == 1) {
        ret x;
    }
    if (y == 2) {
        ret x * x;
    }

    // negative exponents
    if (y < 0) {
        ret 1 / pow(x, -y);
    }

    var result = 1;
    var base = x;
    var exp = y;

    // fast power
    while (exp > 0) {
        if (exp % 2 == 1) {
            result = result * base;
        }
        base = base * base;
        exp = exp / 2;
    }

    ret result;
}