<?php
header('Content-Type: application/json');

$directory = __DIR__ . '/scripts/';

if (!is_dir($directory)) {
    echo json_encode(["error" => "Scripts directory not found."]);
    exit;
}

$files = array_values(array_filter(scandir($directory), function ($file) use ($directory) {
    return is_file($directory . $file) && pathinfo($file, PATHINFO_EXTENSION) === 'lua';
}));

echo json_encode(["files" => $files]);
?>