package org.jnt.crackme.vm.struct;

import org.jnt.crackme.vm.data.Stack;

import java.io.ByteArrayOutputStream;

/**
 * @author etho
 */
public class Function {
    private final byte[] code;

    private final int[][] locals;
    private final Stack stack;

    public Function(byte[] code, int maxStack, int maxLocals) {
        this.stack = new Stack(maxStack);
        this.locals = new int[maxLocals][1];
        this.code = code;
    }

    public byte[] code() {
        return code;
    }

    public Stack stack() {
        return stack;
    }

    public int[][] locals() {
        return locals;
    }
}
