package org.jnt.crackme.vm.def;

public interface Opcodes {
    byte PUSH = 0x0;
    byte PUSH_W = 0x1;
    byte POP = 0x2;

    byte ADD = 0x3;
    byte SUB = 0x4;
    byte DIV = 0x5;
    byte MUL = 0x6;
    byte XOR = 0x7;
    byte NEG = 16;

    byte LDR = 21; // load register
    byte DMP = 22; // dump register

    byte LLD = 23; // local load
    byte LST = 24; // local store

    byte CPY = 25; // most significant!

    byte JMP = 0x8;
    byte JMP_W = 0x9;
    byte DYNJMP = 17;

    byte CALL = 18;
    byte UPCALL = 19;
    byte RET = 20;

    byte IMM0 = 0xa;
    byte IMM1 = 0xb;
    byte IMM2 = 0xc;
    byte IMM3 = 0xd;
    byte IMM4 = 0xe;
    byte IMM5 = 0xf;

    byte ISNULL = 30;
    byte ISLT = 31;
}
