package org.jnt.crackme.vm.data;

import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class UpcallGroup {
    private static final MethodHandle[] UPCALLS;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();

    static {
        try {
            UPCALLS = new MethodHandle[]{
                    LOOKUP.findStatic(System.class, "exit", MethodType.methodType(void.class, int.class)),
                    LOOKUP.findVirtual(PrintStream.class, "println", MethodType.methodType(void.class, String.class)),
                    LOOKUP.findVirtual(List.class, "get", MethodType.methodType(Object.class, int.class)),
                    LOOKUP.findVirtual(List.class, "add", MethodType.methodType(boolean.class, Object.class)),
                    LOOKUP.findVirtual(String.class, "getBytes", MethodType.methodType(byte[].class, Charset.class)),
                    LOOKUP.findVirtual(Map.class, "get", MethodType.methodType(Object.class, Object.class))
            };
        } catch (NoSuchMethodException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle upcallHandle(int index) {
        return UPCALLS[index];
    }
}
