package org.jnt.crackme.vm.data;

import java.util.Optional;

/**
 * @author etho
 */
public class RegisterGroup {
    private final Register[] gpRegisters;
    private final Register[] reserved;
    private final ObjectRegister[] objRegisters;

    public RegisterGroup() {
        gpRegisters = new Register[]{
                new Register(0, 0), // gpA
                new Register(0, 1), // gpB
                new Register(0, 2), // gpC
                new Register(0, 3), // gpD
                new Register(0, 4), // gpE
                new Register(0, 5), // gpF
        };

        reserved = new Register[]{
                new Register(0, 0), // rr

                new Register(0, 1), // arg0
                new Register(0, 2), // arg1
                new Register(0, 3), // arg2
                new Register(0, 4), // arg3
                new Register(0, 5), // arg4
                new Register(0, 6)
        };

        objRegisters = new ObjectRegister[]{
                new ObjectRegister(0, null),
                new ObjectRegister(1, null),
                new ObjectRegister(2, null)
        };
    }

    @SuppressWarnings("unused")
    public Optional<AbstractRegister> lookup(int id, RegisterFamily family) {
        AbstractRegister[] regs = switch (family) {
            case GENERAL_PURPOSE -> gpRegisters;
            case RESERVED -> reserved;
            case OBJECT -> objRegisters;
        };

        for (AbstractRegister reg : regs) {
            if (reg.id() == id) return Optional.of(reg);
        }
        return Optional.empty();
    }

    public enum RegisterFamily {
        GENERAL_PURPOSE, RESERVED, OBJECT
    }
}
