package org.jnt.crackme.unpacker;

import org.jnt.crackme.sdk.Conditions;
import org.jnt.crackme.sdk.Core;
import org.jnt.crackme.sdk.Maps;
import org.jnt.crackme.sdk.Strings;

import java.nio.charset.StandardCharsets;
import java.util.Map;

public class UnpackerClassLoader extends ClassLoader {

    private final Map<String, byte[]> classes;

    public UnpackerClassLoader(Map<String, byte[]> classes) {
        this.classes = classes;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] className = Strings.getBytes(name, StandardCharsets.UTF_8);

        int i = Core.addInt(1, -1);

        do {
            className[i] = (byte) (Core.addInt(Core.mulInt(Core.xorInt(className[i], i), 5), className.length << 2));
            i = Core.addInt(i, 1);
        } while (Conditions.isLessThan(i, className.length));

        byte[] classBytes = (byte[]) Maps.get(classes, new String(className));
        if (Conditions.isNull(classBytes)) {
            return super.findClass(name);
        }

        int j = Core.addInt(1, -1);

        do {
            classBytes[j] = (byte) (Core.xorInt(classBytes[j], j));
            j = Core.addInt(j, 1);
        } while (Conditions.isLessThan(j, classBytes.length));

        return defineClass(name, classBytes, Core.addInt(1, -1), classBytes.length);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return findClass(name);
    }
}
