package org.jnt.crackme.unpacker;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Map;

public class UnpackedBinary {

    private final byte[] data;

    public UnpackedBinary(byte[] data) {
        this.data = data;
    }

    public void asm(Map<String, byte[]> map) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);

        try {
            int entries = dis.readShort();

            for (int i = 0; i < entries; i++) {
                int nameLength = dis.readShort();
                byte[] name = new byte[nameLength];
                for (int j = 0; j < nameLength; j++) {
                    name[j] = (byte) (dis.readByte() ^ j * 5 + nameLength << 2);
                }
                int length = dis.readShort();
                map.put(new String(name), dis.readNBytes(length));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
