package org.jnt.crackme.sdk;

import org.jnt.crackme.vm.VirtualMachine;
import org.jnt.crackme.vm.def.Opcodes;
import org.jnt.crackme.vm.struct.Function;

import java.util.List;

public class Lists {
    private static final byte[] LIST_GET = { 0x00, 0x13, 0x02, 0x01, 0x40 };
    private static final byte[] LIST_ADD = { 0x00, 0x01, 0x13, 0x03, 0x40 };

    public static Object get(List<?> list, int index) {
        VirtualMachine vm = new VirtualMachine(LIST_GET[3]);

        vm.loadObjReg(list, 0);
        vm.reg(new Function(
                new byte[]{
                        LIST_GET[0], (byte) ((index >> Core.subInt(LIST_GET[1], 5)) & 0xff),
                                     (byte) (index & 0xff),
                        LIST_GET[1],
                        LIST_GET[0],
                        LIST_GET[2]
                },
                LIST_GET[4], LIST_GET[0]
        ));
        vm.call(LIST_GET[0]);
        return vm.dumpObjReg(LIST_GET[0]);
    }

    public static void add(List<?> list, Object obj) {
        VirtualMachine vm = new VirtualMachine(LIST_ADD[1]);

        vm.loadObjReg(list, LIST_ADD[0]);
        vm.loadObjReg(obj, LIST_ADD[1]);

        vm.reg(new Function(
                new byte[]{ LIST_ADD[2], LIST_ADD[0], LIST_ADD[3] },
                LIST_ADD[4], LIST_ADD[0]
        ));
        vm.call(LIST_ADD[0]);
    }
}
