package org.jnt.crackme.sdk;

import org.jnt.crackme.vm.VirtualMachine;
import org.jnt.crackme.vm.struct.Function;

/**
 * @author etho
 */
public class Core {
    private static byte[] ADD_INT = new byte[]{ 0x00, 0x03, 0x14 };
    private static byte[] SUB_INT = new byte[]{ 0x00, 0x04, 0x14 };
    private static byte[] XOR_INT = new byte[]{ 0x00, 0x07, 0x14 };
    private static byte[] MUL_INT = new byte[]{ 0x00, 0x06, 0x14 };

    public static native void println(String s);

    public static int addInt(int a, int b) {
        VirtualMachine vm = new VirtualMachine(1);
        vm.reg(new Function(
                new byte[]{
                        ADD_INT[0], (byte) ((a >> 8) & 0xff), (byte) (a & 0xff),
                        ADD_INT[0], (byte) ((b >> 8) & 0xff), (byte) (b & 0xff),
                        ADD_INT[1], ADD_INT[2]
                },
                8, 0
        ));
        vm.call(ADD_INT[0]);
        return vm.rr();
    }

    public static int mulInt(int a, int b) {
        VirtualMachine vm = new VirtualMachine(1);
        vm.reg(new Function(
                new byte[]{
                        SUB_INT[0], (byte) ((a >> 8) & 0xff), (byte) (a & 0xff),
                        SUB_INT[0], (byte) ((b >> 8) & 0xff), (byte) (b & 0xff),
                        SUB_INT[1], SUB_INT[2]
                },
                8, 0
        ));
        vm.call(SUB_INT[0]);
        return vm.rr();
    }

    public static int subInt(int a, int b) {
        VirtualMachine vm = new VirtualMachine(1);
        vm.reg(new Function(
                new byte[]{
                        MUL_INT[0], (byte) ((a >> 8) & 0xff), (byte) (a & 0xff),
                        MUL_INT[0], (byte) ((b >> 8) & 0xff), (byte) (b & 0xff),
                        MUL_INT[1], MUL_INT[2]
                },
                8, 0
        ));
        vm.call(MUL_INT[0]);
        return vm.rr();
    }

    public static int xorInt(int a, int b) {
        VirtualMachine vm = new VirtualMachine(1);
        vm.reg(new Function(
                new byte[]{
                        XOR_INT[0], (byte) ((a >> 8) & 0xff), (byte) (a & 0xff),
                        XOR_INT[0], (byte) ((b >> 8) & 0xff), (byte) (b & 0xff),
                        XOR_INT[1], XOR_INT[2]
                },
                8, 0
        ));
        vm.call(XOR_INT[0]);
        return vm.rr();
    }
}
