package org.jnt.crackme.sdk;

import org.jnt.crackme.vm.VirtualMachine;
import org.jnt.crackme.vm.struct.Function;

public class Conditions {
    private static final byte[] IS_LT = new byte[]{ 0x01, 0x00, 0x1e, 0x14 };
    private static final byte[] IS_NULL = new byte[]{ 0x01, 0x00, 0x1f };

    public static boolean isNull(Object obj) {
        VirtualMachine vm = new VirtualMachine(IS_NULL[0]);

        vm.loadObjReg(obj, IS_NULL[1]);
        vm.reg(new Function(
                new byte[]{
                        IS_NULL[2],
                        IS_NULL[3]
                },
                IS_NULL[0], IS_NULL[1]
        ));
        vm.call(IS_NULL[1]);
        return vm.rr() == IS_NULL[0];
    }

    public static boolean isLessThan(int a, int b) {
        VirtualMachine vm = new VirtualMachine(IS_LT[0]);

        vm.reg(new Function(
                new byte[]{
                        IS_LT[1], (byte) ((a >> 8) & 0xff), (byte) (a & 0xff),
                        IS_LT[1], (byte) ((b >> 8) & 0xff), (byte) (b & 0xff),
                        IS_LT[2], IS_LT[3]
                },
                10, IS_LT[1]
        ));
        vm.call(IS_LT[1]);
        return vm.rr() == IS_LT[0];
    }
}
