package org.jnt.crackme.packer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class PackerEntry {
    private final String name;
    private final byte[] data;

    public PackerEntry(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    public byte[] asm() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);

        try {
            dos.writeShort(name.length());
            dos.write(name.getBytes(StandardCharsets.UTF_8));

            dos.writeShort(data.length);

            for (int i = 0; i < data.length; i++) {
                dos.writeByte(data[i] ^ i);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

        return baos.toByteArray();
    }
}
