package org.jnt.crackme.packer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PackerCore {
    public static void main(String[] args) throws IOException {
        byte[] originalA = Files.readAllBytes(Paths.get("TestA.class"));
        byte[] originalB = Files.readAllBytes(Paths.get("TestB.class"));

        PackedBinary bin = new PackedBinary(
                new PackerEntry[]{
                        new PackerEntry("TestA", originalA),
                        new PackerEntry("TestB", originalB)
                }
        );
        Files.write(Paths.get("packed.bin"), bin.asm());
    }
}
