package org.jnt.crackme.packer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PackedBinary {
    private final PackerEntry[] entries;

    public PackedBinary(PackerEntry[] entries) {
        this.entries = entries;
    }

    public byte[] asm() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);

        try {
            dos.writeShort(entries.length);
        } catch (IOException e) {
            e.printStackTrace();
        }

        for (int i = 0; i < entries.length; i++) {
            PackerEntry entry = entries[i];

            try {
                baos.write(entry.asm());
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baos.toByteArray();
    }
}
