package org.jnt.matrix.wrapper;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.lift.IRLifter;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.jnt.matrix.logger.LogLevel;
import org.jnt.matrix.logger.Logger;
import org.objectweb.asm.tree.MethodNode;

import java.util.ArrayList;
import java.util.List;

/**
 * Wraps around the ASM MethodNode to provide easier usage for utils
 * @author marie
 */
public final class MethodWrapper {

    /**
     * Parent ClassWrapper
     */
    public final ClassWrapper parent;

    /**
     * Statements provided by the IR
     */
    public final List<IStmt> stmts;

    /**
     * Base node
     */
    public final MethodNode base;

    public MethodWrapper(final ClassWrapper parent, final MethodNode base) {
        this.parent = parent;
        this.base = base;
        this.stmts = new ArrayList<>();
        CompilerSheet sheet = new CompilerSheet();

        try {
            new IRLifter(null).lift(base).forEach(stmt -> {
                stmt.compile(sheet);
                this.stmts.add(stmt);
            });
        } catch (Exception e) {
            Logger.log(LogLevel.WARN, "Failed to lift " + base.name + base.desc + " to IR.");
        }
    }

    public String fullName() {
        return parent.base.name + "#" + base.name + base.desc;
    }

    public void compileIR() {
        CompilerSheet sheet = new CompilerSheet();

        stmts.forEach(stmt -> {
            stmt.compile(sheet);
        });

        base.instructions.clear();
        base.instructions.add(sheet.compile());
    }

    public IRPrinter printIR() {
        IRPrinter printer = new IRPrinter();

        stmts.forEach(stmt -> {
            stmt.print(printer);
        });
        return printer;
    }
}
