package org.jnt.matrix.wrapper;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

import java.util.HashMap;

/**
 * Wraps around the ASM ClassNode to provide easier usage for utils
 * @author marie
 */
public final class ClassWrapper {

    /**
     * MethodWrappers that have this class as their parent
     */
    public final HashMap<String, MethodWrapper> methods = new HashMap<>();

    /**
     * FieldWrappers that have this class as their parent
     */
    public final HashMap<String, FieldWrapper> fields = new HashMap<>();

    /**
     * Base node
     */
    public final ClassNode base;

    /**
     * Original bytes of the class
     */
    public final byte[] bytes;

    public ClassWrapper(final byte[] bytes, final ClassNode c) {
        this.bytes = bytes;
        this.base = c;

        ClassWriter writer = new ClassWriter(ClassWriter.COMPUTE_MAXS | ClassWriter.COMPUTE_FRAMES);
        base.accept(writer);

        for (MethodNode method : c.methods) {
            this.methods.put(method.name + method.desc, new MethodWrapper(this, method));
        }
        c.methods.clear();

        for (FieldNode field : c.fields) {
            this.fields.put(field.name, new FieldWrapper(this, field));
        }
        c.fields.clear();
    }

    public void prepareForWrite() {
        for (MethodWrapper value : this.methods.values()) {
            value.compileIR();
            this.base.methods.add(value.base);
        }

        for (FieldWrapper value : this.fields.values()) {
            this.base.fields.add(value.base);
        }
    }
}
