package org.jnt.matrix.ir.stmt.impl;

import org.jnt.matrix.ir.asm.InsnBuilder;
import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.expr.impl.ArithmeticExpr;
import org.jnt.matrix.ir.expr.impl.ConstantExpr;
import org.jnt.matrix.ir.expr.impl.StaticCallExpr;
import org.jnt.matrix.ir.expr.impl.VirtualCallExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;

import static org.objectweb.asm.Type.*;

/**
 * @author etho
 */
public class ReturnStmt implements IStmt {
    private final IExpr expr;

    public ReturnStmt(IExpr expr) {
        this.expr = expr;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        // compile the statement back to bytecode using CompilerSheet#register
        InsnBuilder b = new InsnBuilder();

        if (expr != null) {
            expr.compile(sheet);
        }

        switch (expr) {
            case ConstantExpr constExpr -> {
                switch (constExpr.getType().getSort()) {
                    case INT -> b.ireturn();
                    case FLOAT -> b.freturn();
                    case DOUBLE -> b.dreturn();
                    case LONG -> b.lreturn();
                    default -> b.areturn();
                }
            }
            case ArithmeticExpr arithExpr -> {
                switch (arithExpr.getType().getSort()) {
                    case INT -> b.ireturn();
                    case FLOAT -> b.freturn();
                    case DOUBLE -> b.dreturn();
                    case LONG -> b.lreturn();
                    default -> b.areturn();
                }
            }
            case StaticCallExpr staticCallExpr -> {
                switch (staticCallExpr.getType().getSort()) {
                    case INT -> b.ireturn();
                    case FLOAT -> b.freturn();
                    case DOUBLE -> b.dreturn();
                    case LONG -> b.lreturn();
                    default -> b.areturn();
                }
            }
            case VirtualCallExpr virtualCallExpr -> {
                switch (virtualCallExpr.getType().getSort()) {
                    case INT -> b.ireturn();
                    case FLOAT -> b.freturn();
                    case DOUBLE -> b.dreturn();
                    case LONG -> b.lreturn();
                    default -> b.areturn();
                }
            }
            case null -> b._return();
            default -> {
            }
        }

        sheet.register(b.build());
    }

    @Override
    public void print(IRPrinter printer) {
        printer.tab().out("return").space();

        if (expr != null) {
            expr.print(printer);
        }

        printer.nl();
    }
}
