package org.jnt.matrix.ir.stmt.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

/**
 * @author etho
 */
public class RawJumpStmt implements IStmt {
    private LabelNode label;

    public RawJumpStmt(LabelNode label) {
        this.label = label;
    }

    @Override
    public void print(IRPrinter printer) {
        printer.tab()
                .out("@rawjmp")
                .space()
                .out("b" + label.getLabel().getOffset())
                .nl();
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();

        list.add(new JumpInsnNode(Opcodes.GOTO, label));
        sheet.register(list);
    }
}
