package org.jnt.matrix.ir.stmt.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;

/**
 * @author etho
 */
public class PopStmt implements IStmt {
    private final IExpr expr;

    public PopStmt(IExpr expr) {
        this.expr = expr;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();

        expr.compile(sheet);

        if (expr.getType() != Type.VOID_TYPE) {
            list.add(new InsnNode(Opcodes.POP));
            sheet.register(list);
        }
    }

    @Override
    public void print(IRPrinter printer) {
        printer.tab();

        if (expr != null) {
            expr.print(printer);
        } else {
            printer.out("@nullpop!");
        }

        printer.nl();
    }
}
