package org.jnt.matrix.ir.stmt.impl;

import org.jnt.matrix.ir.asm.InsnBuilder;
import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.objectweb.asm.Type;

import static org.objectweb.asm.Opcodes.*;

/**
 * @author etho
 */
public class NewVarStmt implements IStmt {
    private final IExpr expr;
    private final Type type;
    private final int index;
    private final boolean synth;

    public NewVarStmt(IExpr expr, Type type, int index, boolean synth) {
        this.expr = expr;
        this.type = type;
        this.index = index;
        this.synth = synth;
    }

    @Override
    public void print(IRPrinter printer) {
        if (synth) {
            printer.tab()
                    .out("@def_synth")
                    .space();
        } else {
            printer.tab()
                    .out("@define")
                    .space()
                    .out("v" + index)
                    .space()
                    .out("=")
                    .space();
        }
        expr.print(printer);
        printer.nl();
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnBuilder b = new InsnBuilder();

        expr.compile(sheet);

        if (synth) {
            b.dup();
            sheet.register(b.build());
            return;
        }

        switch (type.getSort()) {
            case Type.INT -> b.istore(index);
            case Type.FLOAT -> b.fstore(index);
            case Type.DOUBLE -> b.dstore(index);
            case Type.LONG -> b.lstore(index);
            default -> b.astore(index);
        }

        sheet.register(b.build());
    }
}
