package org.jnt.matrix.ir.stmt.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public class NewBlockStmt implements IStmt {
    private final LabelNode label;

    public NewBlockStmt(LabelNode label) {
        this.label = label;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();
        list.add(label);

        sheet.register(list);
    }

    @Override
    public void print(IRPrinter printer) {
        printer.out("b" + label.getLabel().getOffset() + ":").nl();
    }
}
