package org.jnt.matrix.ir.print;

/**
 * @author etho
 */
public class IRPrinter {
    private final StringBuilder buffer = new StringBuilder();

    public IRPrinter nl() {
        buffer.append('\n');
        return this;
    }

    public IRPrinter space() {
        buffer.append(' ');
        return this;
    }

    public IRPrinter quote() {
        buffer.append('\'');
        return this;
    }

    public IRPrinter dquote() {
        buffer.append('\"');
        return this;
    }

    public IRPrinter tab() {
        buffer.append('\t');
        return this;
    }

    public IRPrinter out(String str) {
        buffer.append(str);
        return this;
    }

    public IRPrinter clean() {
        buffer.delete(0, buffer.length());
        return this;
    }

    public String collect() {
        return buffer.toString();
    }
}
