package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.asm.InsnBuilder;
import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Type;

/**
 * @author etho
 */
public class VarExpr implements IExpr {
    private final int index;
    private final Type type;

    public VarExpr(int index, Type type) {
        this.index = index;
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public void print(IRPrinter printer) {
        printer.out("v" + index);
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnBuilder b = new InsnBuilder();

        switch (type.getSort()) {
            case Type.INT -> b.iload(index);
            case Type.FLOAT -> b.fload(index);
            case Type.DOUBLE -> b.dload(index);
            case Type.LONG -> b.lload(index);
            default -> b.aload(index);
        }

        sheet.register(b.build());
    }
}
