package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

/**
 * @author etho
 */
public class StaticCallExpr implements IExpr {
    private final IExpr[] args;
    private final String owner, name, desc;
    private final int opcode;

    public StaticCallExpr(int opcode, String owner, String name, String desc, IExpr... args) {
        this.opcode = opcode;
        this.args = args;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public Type getType() {
        return Type.getReturnType(desc);
    }

    public IExpr[] getArgs() {
        return args;
    }

    public String getOwner() {
        return owner;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();

        for (int i = 0; i < args.length; i++) {
            args[i].compile(sheet);
        }
        list.add(new MethodInsnNode(opcode, owner, name, desc));

        sheet.register(list);
    }

    @Override
    public void print(IRPrinter printer) {
        printer.out(owner.replace('/', '.')).out(".").out(name + "(");

        for (int i = 0; i < args.length; i++) {
            args[i].print(printer);

            if (i != args.length - 1) {
                printer.out(", ");
            }
        }
        printer.out(")");
    }
}
