package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;

/**
 * @author etho
 */
public class FieldGetExpr implements IExpr {
    private final int opcode;
    private final String owner, name, desc;

    public FieldGetExpr(int opcode, String owner, String name, String desc) {
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();

        list.add(new FieldInsnNode(opcode, owner, name, desc));

        sheet.register(list);
    }

    @Override
    public void print(IRPrinter printer) {
        printer.out(owner.replace('/', '.')).out(".").out(name);
    }

    @Override
    public Type getType() {
        return Type.getType(desc);
    }
}
