package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.asm.InsnBuilder;
import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Type;

import static org.objectweb.asm.Type.*;

/**
 * @author etho
 */
public class ConstantExpr implements IExpr {
    private final Object cst;
    private final Type type;

    public ConstantExpr(Object cst, Type type) {
        this.cst = cst;
        this.type = type;
    }

    public Object getConstant() {
        return cst;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        // compile the expression back to bytecode using CompilerSheet#register
        InsnBuilder b = new InsnBuilder();

        switch (cst) {
            case null -> b.nullCst();
            case String s -> b.ldc(s);
            case Float f -> b.pushFloat(f);
            case Double d -> b.pushDouble(d);
            case Long l -> b.pushLong(l);
            case Integer i -> b.pushInt(i);
            default -> {
                throw new UnsupportedOperationException("Unsupported constant type: " + cst.getClass().getSimpleName());
            }
        }

        sheet.register(b.build());
    }

    @Override
    public void print(IRPrinter printer) {
        switch (type.getSort()) {
            case INT -> printer.out(String.valueOf((int) cst));
            case FLOAT -> printer.out(String.valueOf((float) cst));
            case LONG -> printer.out(String.valueOf((long) cst));
            case DOUBLE -> printer.out(String.valueOf((double) cst));
            default -> printer.dquote().out(String.valueOf(cst)).dquote();
        }
    }
}
