package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.asm.InsnBuilder;
import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Type;

import java.net.Proxy;

/**
 * @author etho
 */
public class ArithmeticExpr implements IExpr {
    private final IExpr a, b;
    private final Type type;
    private final String op;

    public ArithmeticExpr(IExpr a, IExpr b, String op, Type type) {
        this.a = a;
        this.b = b;
        this.op = op;
        this.type = type;
    }

    public IExpr getOperandA() {
        return a;
    }

    public IExpr getOperandB() {
        return b;
    }

    @Override
    public Type getType() {
        return type;
    }

    public String getOp() {
        return op;
    }

    @Override
    public void print(IRPrinter printer) {
        a.print(printer);

        printer.space();
        printer.out(op);
        printer.space();

        b.print(printer);
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnBuilder b = new InsnBuilder();

        getOperandA().compile(sheet);
        getOperandB().compile(sheet);

        switch (type.getSort()) {
            case Type.INT -> {
                switch (getOp()) {
                    case "+" -> b.iadd();
                    case "-" -> b.isub();
                    case "*" -> b.imul();
                    case "/" -> b.idiv();
                    case "^" -> b.ixor();
                    case "&" -> b.iand();
                    case "|" -> b.ior();
                    case "%" -> b.irem();
                    case ">>" -> b.ishr();
                    case "<<" -> b.ishl();
                    case ">>>" -> b.iushr();
                }
            }
            case Type.FLOAT -> {
                switch (getOp()) {
                    case "+" -> b.fadd();
                    case "-" -> b.fsub();
                    case "*" -> b.fmul();
                    case "/" -> b.fdiv();
                    case "%" -> b.frem();
                }
            }
            case Type.DOUBLE -> {
                switch (getOp()) {
                    case "+" -> b.dadd();
                    case "-" -> b.dsub();
                    case "*" -> b.dmul();
                    case "/" -> b.ddiv();
                    case "%" -> b.drem();
                }
            }
            case Type.LONG -> {
                switch (getOp()) {
                    case "+" -> b.ladd();
                    case "-" -> b.lsub();
                    case "*" -> b.lmul();
                    case "/" -> b.ldiv();
                    case "%" -> b.lrem();
                    case "^" -> b.lxor();
                    case "&" -> b.land();
                    case "|" -> b.lor();
                    case ">>" -> b.lshr();
                    case "<<" -> b.lshl();
                    case ">>>" -> b.lushr();
                }
            }
        }
        sheet.register(b.build());
    }
}
