package org.jnt.matrix.ir.expr.impl;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.expr.IExpr;
import org.jnt.matrix.ir.print.IRPrinter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.TypeInsnNode;


/**
 * @author etho
 */
public class AllocateObjectExpr implements IExpr {
    private final Type type;

    public AllocateObjectExpr(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public void compile(CompilerSheet sheet) {
        InsnList list = new InsnList();

        list.add(new TypeInsnNode(Opcodes.NEW, type.getInternalName()));

        sheet.register(list);
    }

    @Override
    public void print(IRPrinter printer) {
        printer.out("new ").out(type.getClassName());
    }
}
