package org.jnt.matrix.base;

import org.jnt.matrix.transformer.AbstractTransformer;
import org.jnt.matrix.util.FileUtil;
import org.jnt.matrix.wrapper.ClassWrapper;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;

/**
 * The core of everything
 * @author marie
 */
public final class DeobfBase {
    public static DeobfBase INSTANCE;

    /**
     * Loaded classes
     */
    public final HashMap<String, ClassWrapper> classes = new HashMap<>();

    /**
     * Loaded non-classes (binary files)
     */
    public final HashMap<String, byte[]> files = new HashMap<>();

    /**
     * Arguments used for the ClassReader
     */
    public final int readerArgs;

    /**
     * Arguments used for the ClassWriter
     */
    public final int writerArgs;

    public DeobfBase(
            final Path input,
            final Path output,
            final int readerArgs,
            final int writerArgs,
            final List<AbstractTransformer> transformers
    ) {
        this.readerArgs = readerArgs;
        this.writerArgs = writerArgs;
        INSTANCE = this;

        FileUtil.loadJar(input);

        transformers.forEach(AbstractTransformer::run);

        FileUtil.saveJar(output);
    }

}
