package org.jnt.matrix;

import org.jnt.matrix.ir.codegen.CompilerSheet;
import org.jnt.matrix.ir.lift.IRLifter;
import org.jnt.matrix.ir.print.IRPrinter;
import org.jnt.matrix.ir.stmt.IStmt;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author etho
 */
public class MatrixStart {
    public static void main(String[] args) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get("Test.class"));

        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);

        reader.accept(node, 0);

        ClassWriter writer = new ClassWriter(ClassWriter.COMPUTE_MAXS | ClassWriter.COMPUTE_FRAMES);
        node.accept(writer);

        IRPrinter printer = new IRPrinter();

        ClassNode recomp = new ClassNode();
        recomp.name = "Test";
        recomp.version = Opcodes.V23;
        recomp.access = Opcodes.ACC_PUBLIC;

        for (var method : node.methods) {
            if (!method.name.equals("test")) continue;

            //if (!method.name.equals("main")) continue;
            CompilerSheet sheet = new CompilerSheet();

            printer.out("\nLift result from " + method.name + method.desc + "\n{").nl();
            new IRLifter(printer).lift(method).forEach(stmt -> {
                stmt.print(printer);
                stmt.compile(sheet);
            });
            printer.out("}").nl();

            method.instructions.clear();
            method.instructions.add(sheet.compile());

            recomp.methods.add(method);
        }

        ClassWriter newWriter = new ClassWriter(ClassWriter.COMPUTE_MAXS);
        recomp.accept(newWriter);

        Files.write(Paths.get("recomp/Test.class"), newWriter.toByteArray());

        System.out.println(printer.collect());

        //ClassWriter writer = new ClassWriter(ClassWriter.COMPUTE_MAXS | ClassWriter.COMPUTE_FRAMES);
        //node.accept(writer);
    }
}
