package dev.name.asm.ir.instructions;

import dev.name.asm.ir.components.Field;
import dev.name.asm.ir.components.Method;
import dev.name.asm.ir.instructions.builders.BasicInstructionBuilder;
import dev.name.asm.ir.nodes.*;
import dev.name.asm.ir.types.Node;
import org.objectweb.asm.Opcodes;

import java.util.function.Consumer;

@SuppressWarnings("all")
public abstract class InstructionBuilder implements Opcodes {
    public static InstructionBuilder generate() {
        return new BasicInstructionBuilder();////
    }

    public abstract InstructionBuilder nop();
    public abstract InstructionBuilder aconst_null();
    public abstract InstructionBuilder iconst_m1();
    public abstract InstructionBuilder iconst_0();
    public abstract InstructionBuilder iconst_1();
    public abstract InstructionBuilder iconst_2();
    public abstract InstructionBuilder iconst_3();
    public abstract InstructionBuilder iconst_4();
    public abstract InstructionBuilder iconst_5();
    public abstract InstructionBuilder lconst_0();
    public abstract InstructionBuilder lconst_1();
    public abstract InstructionBuilder fconst_0();
    public abstract InstructionBuilder fconst_1();
    public abstract InstructionBuilder fconst_2();
    public abstract InstructionBuilder dconst_0();
    public abstract InstructionBuilder dconst_1();
    public abstract InstructionBuilder bipush(final int operand);
    public abstract InstructionBuilder sipush(final int operand);
    public abstract InstructionBuilder ldc(final Object cst);
    public abstract InstructionBuilder iload(final int index);
    public abstract InstructionBuilder lload(final int index);
    public abstract InstructionBuilder fload(final int index);
    public abstract InstructionBuilder dload(final int index);
    public abstract InstructionBuilder aload(final int index);
    public abstract InstructionBuilder iaload();
    public abstract InstructionBuilder laload();
    public abstract InstructionBuilder faload();
    public abstract InstructionBuilder daload();
    public abstract InstructionBuilder aaload();
    public abstract InstructionBuilder baload();
    public abstract InstructionBuilder caload();
    public abstract InstructionBuilder saload();
    public abstract InstructionBuilder istore(final int index);
    public abstract InstructionBuilder lstore(final int index);
    public abstract InstructionBuilder fstore(final int index);
    public abstract InstructionBuilder dstore(final int index);
    public abstract InstructionBuilder astore(final int index);
    public abstract InstructionBuilder iastore();
    public abstract InstructionBuilder lastore();
    public abstract InstructionBuilder fastore();
    public abstract InstructionBuilder dastore();
    public abstract InstructionBuilder aastore();
    public abstract InstructionBuilder bastore();
    public abstract InstructionBuilder castore();
    public abstract InstructionBuilder sastore();
    public abstract InstructionBuilder pop();
    public abstract InstructionBuilder pop2();
    public abstract InstructionBuilder dup();
    public abstract InstructionBuilder dup_x1();
    public abstract InstructionBuilder dup_x2();
    public abstract InstructionBuilder dup2();
    public abstract InstructionBuilder dup2_x1();
    public abstract InstructionBuilder dup2_x2();
    public abstract InstructionBuilder swap();
    public abstract InstructionBuilder iadd();
    public abstract InstructionBuilder ladd();
    public abstract InstructionBuilder fadd();
    public abstract InstructionBuilder dadd();
    public abstract InstructionBuilder isub();
    public abstract InstructionBuilder lsub();
    public abstract InstructionBuilder fsub();
    public abstract InstructionBuilder dsub();
    public abstract InstructionBuilder imul();
    public abstract InstructionBuilder lmul();
    public abstract InstructionBuilder fmul();
    public abstract InstructionBuilder dmul();
    public abstract InstructionBuilder idiv();
    public abstract InstructionBuilder ldiv();
    public abstract InstructionBuilder fdiv();
    public abstract InstructionBuilder ddiv();
    public abstract InstructionBuilder irem();
    public abstract InstructionBuilder lrem();
    public abstract InstructionBuilder frem();
    public abstract InstructionBuilder drem();
    public abstract InstructionBuilder ineg();
    public abstract InstructionBuilder lneg();
    public abstract InstructionBuilder fneg();
    public abstract InstructionBuilder dneg();
    public abstract InstructionBuilder ishl();
    public abstract InstructionBuilder lshl();
    public abstract InstructionBuilder ishr();
    public abstract InstructionBuilder lshr();
    public abstract InstructionBuilder iushr();
    public abstract InstructionBuilder lushr();
    public abstract InstructionBuilder iand();
    public abstract InstructionBuilder land();
    public abstract InstructionBuilder ior();
    public abstract InstructionBuilder lor();
    public abstract InstructionBuilder ixor();
    public abstract InstructionBuilder lxor();
    public abstract InstructionBuilder iinc(final int index, final int amount);
    public abstract InstructionBuilder i2l();
    public abstract InstructionBuilder i2f();
    public abstract InstructionBuilder i2d();
    public abstract InstructionBuilder l2i();
    public abstract InstructionBuilder l2f();
    public abstract InstructionBuilder l2d();
    public abstract InstructionBuilder f2i();
    public abstract InstructionBuilder f2l();
    public abstract InstructionBuilder f2d();
    public abstract InstructionBuilder d2i();
    public abstract InstructionBuilder d2l();
    public abstract InstructionBuilder d2f();
    public abstract InstructionBuilder i2b();
    public abstract InstructionBuilder i2c();
    public abstract InstructionBuilder i2s();
    public abstract InstructionBuilder lcmp();
    public abstract InstructionBuilder fcmpl();
    public abstract InstructionBuilder fcmpg();
    public abstract InstructionBuilder dcmpl();
    public abstract InstructionBuilder dcmpg();
    public abstract InstructionBuilder ifeq(final Label label);
    public abstract InstructionBuilder ifne(final Label label);
    public abstract InstructionBuilder iflt(final Label label);
    public abstract InstructionBuilder ifge(final Label label);
    public abstract InstructionBuilder ifgt(final Label label);
    public abstract InstructionBuilder ifle(final Label label);
    public abstract InstructionBuilder if_icmpeq(final Label label);
    public abstract InstructionBuilder if_icmpne(final Label label);
    public abstract InstructionBuilder if_icmplt(final Label label);
    public abstract InstructionBuilder if_icmpge(final Label label);
    public abstract InstructionBuilder if_icmpgt(final Label label);
    public abstract InstructionBuilder if_icmple(final Label label);
    public abstract InstructionBuilder if_acmpeq(final Label label);
    public abstract InstructionBuilder if_acmpne(final Label label);
    public abstract InstructionBuilder jump(final Label label);
    public abstract InstructionBuilder jsr(final Label label);
    public abstract InstructionBuilder ret(final Label label);
    public abstract InstructionBuilder tableswitch(final Table table);
    public abstract InstructionBuilder tableswitch(final int min, final int max, final Label _default, final Label... labels);
    public abstract InstructionBuilder lookupswitch(final Lookup lookup);
    public abstract InstructionBuilder lookupswitch(final Label _default, final int[] keys, final Label... labels);
    public abstract InstructionBuilder ireturn();
    public abstract InstructionBuilder lreturn();
    public abstract InstructionBuilder freturn();
    public abstract InstructionBuilder dreturn();
    public abstract InstructionBuilder areturn();
    public abstract InstructionBuilder _return();
    public abstract InstructionBuilder access(final Accessor field);
    public abstract InstructionBuilder getfield(final String owner, final String name, final String desc);
    public abstract InstructionBuilder getfield(final String owner, final String name, final Class<?> klass);
    public abstract InstructionBuilder putfield(final String owner, final String name, final String desc);
    public abstract InstructionBuilder putfield(final String owner, final String name, final Class<?> klass);
    public abstract InstructionBuilder getstatic(final String owner, final String name, final String desc);
    public abstract InstructionBuilder getstatic(final String owner, final String name, final Class<?> klass);
    public abstract InstructionBuilder putstatic(final String owner, final String name, final String desc);
    public abstract InstructionBuilder putstatic(final String owner, final String name, final Class<?> klass);
    public abstract InstructionBuilder invoke(final Invoke method);
    public abstract InstructionBuilder invokestatic(final String owner, final String name, final String desc, final boolean _interface);
    public abstract InstructionBuilder invokevirtual(final String owner, final String name, final String desc, final boolean _interface);
    public abstract InstructionBuilder invokespecial(final String owner, final String name, final String desc);
    public abstract InstructionBuilder invokeinterface(final String owner, final String name, final String desc);
    public abstract InstructionBuilder invokedynamic(final Dynamic dynamic);
    public abstract InstructionBuilder _new(final String desc);
    public abstract InstructionBuilder _new(final Class<?> klass);
    public abstract InstructionBuilder newarray(final String desc);
    public abstract InstructionBuilder newarray(final Class<?> klass);
    public abstract InstructionBuilder anewarray(final String desc);
    public abstract InstructionBuilder anewarray(final Class<?> klass);
    public abstract InstructionBuilder arraylength();
    public abstract InstructionBuilder athrow();
    public abstract InstructionBuilder checkcast(final String desc);
    public abstract InstructionBuilder checkcast(final Class<?> klass);
    public abstract InstructionBuilder _instanceof(final String desc);
    public abstract InstructionBuilder _instanceof(final Class<?> klass);
    public abstract InstructionBuilder monitorenter();
    public abstract InstructionBuilder monitorexit();
    public abstract InstructionBuilder multianewarray(final Array array);
    public abstract InstructionBuilder multianewarray(final String desc, final int dimensions);
    public abstract InstructionBuilder multianewarray(final Class<?> klass, final int dimensions);
    public abstract InstructionBuilder ifnull(final Label label);
    public abstract InstructionBuilder ifnonnull(final Label label);
    // --
    public abstract InstructionBuilder bind(final Label label);
    public abstract Label label();
    public abstract Label newlabel();
    public abstract InstructionBuilder get(final Field field);
    public abstract InstructionBuilder put(final Field field);
    public abstract InstructionBuilder invoke(final Method method);
    public abstract InstructionBuilder load(final Variable variable);
    public abstract InstructionBuilder store(final Variable variable);
    public abstract InstructionBuilder increment(final Increment incr);
    public abstract InstructionBuilder constant(final Constant constant);
    public abstract InstructionBuilder frame(final Frame frame);
    // --
    public abstract InstructionBuilder add(final Node node);
    public abstract InstructionBuilder add(final Instructions instructions);
    public abstract InstructionBuilder set(final Node node, final Node replacement);
    public abstract InstructionBuilder set(final Node node, final Instructions instructions);
    public abstract InstructionBuilder insertBefore(final Node existing, final Node node);
    public abstract InstructionBuilder insertBefore(final Node node, final Instructions instructions);
    public abstract InstructionBuilder insertAfter(final Node existing, final Node node);
    public abstract InstructionBuilder insertAfter(final Node node, final Instructions instructions);
    // --
    public abstract Instructions build();
    public abstract void forEach(final Consumer<Node> consumer);
}