#version 140

uniform mat4 u_modelView;
uniform mat4 u_projection;
uniform vec2 u_textBoundsMin;
uniform vec2 u_textBoundsMax;

in vec3 in_position;
in vec2 in_texCoords;
in vec4 in_color;

out vec2 texCoords;
out vec4 color;
out vec2 fragPosition;

void main()
{
    gl_Position = u_projection * u_modelView * vec4(in_position, 1.0);
    texCoords = in_texCoords;
    color = in_color;
    fragPosition = in_position.xy;
}