#version 140

uniform float u_threshold;
uniform float u_smoothing;
uniform sampler2D u_texture;
uniform vec2 u_textBoundsMin;
uniform vec2 u_textBoundsMax;
uniform vec4 u_gradientStartColor;
uniform vec4 u_gradientEndColor;
uniform float u_tiltFactor;
uniform int u_useGradient;
uniform float u_offset;

in vec2 texCoords;
in vec4 color;
in vec2 fragPosition;

out vec4 out_color;

void main()
{
    float distance = texture(u_texture, texCoords).r;
    float alpha = smoothstep(u_threshold - u_smoothing * u_threshold, u_threshold + u_smoothing * (1.0 - u_threshold), distance);

    vec4 finalColor;
    if (u_useGradient == 1) {
        float xProgress = (fragPosition.x - u_textBoundsMin.x) / (u_textBoundsMax.x - u_textBoundsMin.x);
        float yProgress = (fragPosition.y - u_textBoundsMin.y) / (u_textBoundsMax.y - u_textBoundsMin.y);
        float progress = xProgress + yProgress * u_tiltFactor + u_offset;
        progress = fract(progress);
        float smoothProgress = 0.5 + 0.5 * sin(progress * 3.14159 * 2.0);
        finalColor = mix(u_gradientStartColor, u_gradientEndColor, smoothProgress);
        finalColor.a = color.a;
    } else {
        finalColor = color;
    }

    out_color = vec4(finalColor.rgb, finalColor.a * alpha);
}